#version 460 core

layout (location = 0) in vec3 Position;
layout (location = 1) in vec2 TexCoords;
layout (location = 2) in vec3 Normals;

// Uniform inputs
uniform mat4 PVM;

//out vec4 FragColor;
//out vec2 FragTexCoords;
//out mat4 PVM;

float near = 0.1f;
float far = 4.0f;
float LinearizeDepth(float depth)
{
	float z = depth * 2.0f - 1.0f; // back to NDC
	return (2.0f * near * far) / (far + near - z * (far - near));
}

void main()
{
	gl_Position = PVM * vec4(Position, 1.f);
	//FragTexCoords = TexCoords;
}
