#version 460 core

in vec3 FragColor;
in vec2 FragTexCoords;

// uniform inputs
uniform sampler2D ImageTexture0;
uniform sampler2D ImageTexture1;
uniform float BlendRatio;

out vec4 FinalColor;

float near = 0.1f;
float far = 1000.0f;

float LinearizeDepth(float depth)
{
	float z = depth * 2.0f - 1.0f; // back to NDC
	return (2.0f * near * far) / (far + near - z * (far - near));
}



void main()
{
	float depth = LinearizeDepth(gl_FragCoord.z) / far; // divide by far for demonstartion
	FinalColor = mix(texture(ImageTexture0, FragTexCoords), texture(ImageTexture1, FragTexCoords), BlendRatio);
	//FinalColor = vec4(vec3(depths), 1.0);
}
