#version 460 core

layout (triangles) in;
layout (line_strip, max_vertices = 6) out;

uniform mat4 PVM;

in VS_GS_VERTEX
{
	in vec4 Position;
	in vec3 Normal;
} vs_out[];

void main()
{
    float Length = 0.01f;
    
    for (int i = 0; i < 3; ++i)
    {
        gl_Position = vs_out[i].Position;
        EmitVertex();

        vec3 NormalizedNormal = normalize(vs_out[i].Normal);
        gl_Position = vs_out[i].Position + PVM * vec4(NormalizedNormal, 0.0f) * Length;
        EmitVertex();

        EndPrimitive();
    }
}
