#version 460 core

layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

uniform mat4 PV;
//uniform vec3 QuadAxisX;
//uniform vec3 QuadAxisY;

vec3 QuadAxisX;
vec3 QuadAxisY;

uniform vec3 CameraPos;
uniform vec3 CameraUpDir = vec3(0,1,0);
uniform bool EnableBillboarding = true;

out vec2 TexCoord;

vec2 Pos2TexCoord(vec2 Position)
{
    return Position * 0.5f + 0.5f;
}

void MakeVertex(vec2 Offset, float Size)
{
    vec3 Point;
    if (EnableBillboarding)
    {
        Point = gl_in[0].gl_Position.xyz + (Offset.x * QuadAxisX - Offset.y * QuadAxisY) * Size;
    }
    else
    {
        Point = gl_in[0].gl_Position.xyz + vec3(Offset.x, Offset.y, 0) * Size;
    }
    gl_Position = PV * vec4(Point, 1.f);
    TexCoord = Pos2TexCoord(Offset);
    EmitVertex();
}

void main()
{
    if (EnableBillboarding)
    {
        // Calculate billboard values
        vec3 CameraFront = normalize(gl_in[0].gl_Position.xyz - CameraPos);
        QuadAxisX = normalize(cross(CameraFront, CameraUpDir));
        QuadAxisY = normalize(cross(CameraFront, QuadAxisX));
    }

    //vec3 QuadAxisX

    float Size = 0.3f;
    MakeVertex(vec2(-1,-1), Size);
    MakeVertex(vec2( 1,-1), Size);
    MakeVertex(vec2(-1, 1), Size);
    MakeVertex(vec2( 1, 1), Size);
    EndPrimitive();
}
