#version 460 core

in vec3 FragTexCoords;
in vec3 FragPos;

uniform samplerCube ImageTexture0;
uniform vec3 CameraPos;

out vec4 FinalColor;


// === FOG ==== //
struct LinearFog
{
	float start;
	float end;
	float maximum;
	vec4  color;
};

uniform int enableFog = 0;

uniform LinearFog fog = {
	25.0f,
	200.0f,
	0.97f,
	vec4(0.4f, 0.4f, 0.4f, 1.0f)
};

vec4 CalculateLinearFog(vec4 color)
{
	if (enableFog == 0)
	{
		return color;
	}
	float Dist = distance(FragPos, CameraPos);
	float FogFactor = (Dist - fog.start) / fog.end;
	FogFactor = clamp(FogFactor, 0.0f, fog.maximum);
	return mix(color, fog.color, FogFactor);
}
// === End Fog == //


void main()
{
    FinalColor = CalculateLinearFog(texture(ImageTexture0, FragTexCoords));
}