#version 460 core

layout (points) in;
layout (triangle_strip, max_vertices = 20) out;

uniform mat4 PVM;

in VS_GS_VERTEX
{
	in vec4 Position;
} gs_in[];

out vec2 FragTexCoords;

//out GS_FS_TEXCOORD
//{
//    out vec2 TexCoord;
//} gs_out[];

vec2 ToFragCoord(vec2 ndc)
{
    return vec2((ndc.x + 1.f) * 0.5f, (ndc.y + 1.f) * 0.5f);
}

int iMod(int  x, int y)
{
    int count = (x + y)/y;
    return x + y - (y * count);
}

vec2 RadialPos(float degrees)
{
    float rad = radians(degrees);
    return vec2(cos(rad), sin(rad));
}

void AddVert(vec2 pos)
{
	gl_Position = gs_in[0].Position + PVM * vec4(pos, 0.f, 1.f);
    //gs_out[0].TexCoord = ToFragCoord(pos);
    FragTexCoords = ToFragCoord(pos);
	EmitVertex();
}

void AddFace(vec2 p1, vec2 p2, vec2 p3)
{
    AddVert(p1);
    AddVert(p2);
    AddVert(p3);
    EndPrimitive();
}

void main()
{
    // store the positions of each radial vertex
    float r = 0.5f;//2.f/3.f;
    vec2[10] circle;
    for (int i = 0; i < 10; ++i)
    {
        if (i%2 == 0)
            circle[i] = RadialPos(i/10.f * 360.f + 90.f);
        else
            circle[i] = r * RadialPos(i/10.f * 360.f + 90.f);
    }
    // make the arms of the star
    for (int i=0; i < 5; ++i)
    {
        AddFace(circle[2*i], circle[2*i + 1], circle[iMod(2*i - 1, 10)]);
    }
    // make the interior pentagon
    AddVert(circle[3]);
    AddVert(circle[5]);
    AddVert(circle[1]);
    AddVert(circle[7]);
    AddVert(circle[9]);
    EndPrimitive();
}
