#version 460 core

layout (location = 0) in vec4 Vertex; // (vec3 Pos, vec2: TexCoords)

out vec2 FragTextCoords;

uniform mat4 ProjectionMat;

uniform float Width;
uniform float Padding;
uniform float T;

void main()
{
	float x = Padding + T * Width;
	if (x > Width)
	{
		x = x - Width;
	}
	
	gl_Position = ProjectionMat * vec4(Vertex.x - Padding + x, Vertex.y, 0.f, 1.f);
	FragTextCoords = Vertex.zw;
}
