#version 460 core

in vec2 FragTexCoords;
in vec3 FragNormal;
out vec3 FragPos; // Attemping to change this to 'in' breaks an entirely different Program (for regular models) for reasons I cannot begin to fathom
in vec3 LocalPos;

out vec4 FinalColor;

uniform vec3 CameraPos;
uniform sampler3D ImageTexture0;
uniform float Scaler;
uniform float YOffset;

// === FOG ==== //
struct LinearFog
{
	float start;
	float end;
	float maximum;
	vec4  color;
};

uniform int enableFog = 1;

uniform LinearFog fog = {
	25.0f,
	200.0f,
	0.97f,
	vec4(0.4f, 0.4f, 0.4f, 1.0f)
};

vec4 CalculateLinearFog(vec4 color)
{
	if (enableFog == 0)
	{
		return color;
	}
	float Dist = distance(FragPos, CameraPos);
	float FogFactor = (Dist - fog.start) / fog.end;
	FogFactor = clamp(FogFactor, 0.0f, fog.maximum);
	return mix(color, fog.color, FogFactor);
}
// === End Fog == //


void main()
{
    vec3 scaled = LocalPos * 2.f + 0.5f;
	float remainder = (scaled.y+Scaler) - floor(scaled.y + Scaler);
    vec3 SampleLocation = vec3(scaled.x, remainder, scaled.z);
    vec4 Color3D = texture(ImageTexture0, SampleLocation);
    FinalColor = CalculateLinearFog(Color3D);
}