#version 460 core

layout (vertices = 3) out; // quadpatch

uniform vec3 CameraPos;

float CameraToVertexDist(vec4 Position)
{
    return distance(CameraPos, Position.xyz);
}

void main()
{
    if (gl_InvocationID == 0) // set once per patch
    {
        vec4 d = vec4(
            CameraToVertexDist(gl_in[0].gl_Position),
            CameraToVertexDist(gl_in[1].gl_Position),
            CameraToVertexDist(gl_in[2].gl_Position),
            CameraToVertexDist(gl_in[3].gl_Position)
        );
    
        float lodLevel = max(2000 / d[0], 2);
        
        gl_TessLevelOuter[0] = lodLevel;//5.0f;
        gl_TessLevelOuter[1] = lodLevel;//5.0f;
        gl_TessLevelOuter[2] = lodLevel;//5.0f;
        gl_TessLevelInner[0] = lodLevel;//7.0f;
    }
    gl_out[gl_InvocationID].gl_Position = gl_in[gl_InvocationID].gl_Position;
}
